CARAVAN3_SPAWNCOUNT = 1
CARAVAN3_RESPAWNCOUNT = 11
CARAVAN3_NECESSARY_AMOUNT = 9

function StartLastCaravan()

	
	-- next caravan		
	Caravan3JobId = StartSimpleJob("QuestCaravan3")

	Caravan3SpawnTime = 180
	Caravan3SpawnCount = 1
	
	leftpatrolSpawner.ArmySize = leftpatrolSpawner.ArmySize + 2
	middlepatrolSpawner.ArmySize = middlepatrolSpawner.ArmySize + 2
	rightpatrolSpawner.ArmySize = rightpatrolSpawner.ArmySize + 2
	
	overalltributes = 205
	Caravan3Counter = 0
	paidResources = 0
	Caravan3SurvivedCounter = 0
	
	CreateTributeForMoreCaravan3()

	GUIQuestTools.StartQuestInformation("Caravan", "CM02_04_TradingCaravans/QI_caravan2", 1, 1)	

	UpdateCaravan3CountInQuestInformation()
end

function UpdateCaravan3CountInQuestInformation()
	GUIQuestTools.UpdateQuestInformationString(Caravan3SurvivedCounter .. "/" .. CARAVAN3_NECESSARY_AMOUNT)
end

function CreateTributeForMoreCaravan3()
	local _L = {}
		for i = 201,204,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Capulet die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allem", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
	end
end

function createNextTributes3(_wanted)
	local _L = {}
		for i = (overalltributes+1),overalltributes+_wanted,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Capulet die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allen Rohstoffen.", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
		end
	overalltributes = overalltributes + _wanted + 1
end

function QuestCaravan3()


	if IsBriefingActive() then
		return false
	end

	if Caravan3StartTime == nil then
		
		Caravan3StartTime = Caravan3SpawnTime
		Counter.SetLimit("QuestCaravan3",Caravan3StartTime)

		-- show time
		MapLocal_StartCountDown(Caravan3StartTime)
	
	end

	if Counter.Tick("QuestCaravan3") then

		MapLocal_StopCountDown()
		local spawncaravans = CARAVAN3_SPAWNCOUNT + paidResources
		
		if (spawncaravans + Caravan3SpawnCount) > CARAVAN3_RESPAWNCOUNT then
			spawncaravans = CARAVAN3_RESPAWNCOUNT -  Caravan3SpawnCount
		end
		-- create caravan
		for i=1,spawncaravans do
			CreateEntity(7,Entities.PU_Travelling_Salesman,GetPosition("Caravan3SpawnPoint"..i),"Caravan_"..Caravan3SpawnCount.."_"..i)
		end
		
		local Quest 		= {}
		Quest.Unit 			= "Caravan_"..Caravan3SpawnCount.."_"
		
		Quest.Waypoint 	= {}
		
		Quest.Waypoint[1] = { Name = "Caravan_WP5", WaitTime = 60 }
		Quest.Waypoint[2] = { Name = "Caravan_WP2", WaitTime = 60 }
		Quest.Waypoint[3] = { Name = "Caravan_WP3", WaitTime = 60 }
		Quest.Waypoint[4] = { Name = "Caravan_WP4", WaitTime = 60 }
		
		Quest.Remove 		= true		
	
		Quest.Callback 			= QuestCaravan3Done
		Quest.ArrivedCallback 	= QuestCaravan3UpdateSurvivedCounter
	
		SetupCaravan(Quest)
	
		Caravan3SpawnCount = Caravan3SpawnCount + spawncaravans
		
		if Caravan3SpawnCount <= CARAVAN3_RESPAWNCOUNT+1 then
			
			if (Caravan3SpawnCount + paidResources) > CARAVAN3_RESPAWNCOUNT then
				paidResources = CARAVAN3_RESPAWNCOUNT -  Caravan3SpawnCount - 1
			end
			if (CARAVAN3_RESPAWNCOUNT - Caravan3SpawnCount) <= 3 then
				for i = 200, overalltributes,1 do
					Logic.RemoveTribute(1,i)
				end
				paidResources = (CARAVAN3_RESPAWNCOUNT - (Caravan3SpawnCount + 1))
			end
			
			createNextTributes3(paidResources)
			paidResources = 0
			Caravan3StartTime = nil
			Caravan3SpawnTime = 270
			
			Caravan3JobId = StartSimpleJob("QuestCaravan3")

		end
		
		--StartCutscene
		StartCutscene(Cutscenes[THRESHOLDONECUTSCENE])
	
		return true
	
	end

end

function QuestCaravan3UpdateSurvivedCounter(_Quest)
	if caravan3ended == true then
		return
	end

	Caravan3SurvivedCounter = Caravan3SurvivedCounter + 1

	UpdateCaravan3CountInQuestInformation()

end

function QuestCaravan3Done(_Quest)
	if caravan3ended == true then
		return
	end

	Caravan3Counter = Caravan3Counter + _Quest.ArrivedCount
	
	if Caravan3SurvivedCounter >= CARAVAN3_NECESSARY_AMOUNT then
	
		GUIQuestTools.DisableQuestInformation()
		
		for i =1, overalltributes,1 do
			Logic.RemoveTribute(1,i)
		end
	
		EndJob(Caravan3JobId)
		MapLocal_StopCountDown()
		
		caravan3ended = true
		
		end5thChapter()

	elseif Caravan3Counter == CARAVAN3_RESPAWNCOUNT then

		Defeat()

	end
		
end
